function X_noisy = add_noise_rectangular(X,sigma_re,sigma_im,Bad_Data)
% X_noisy = add_noise_rectangular(X,sigma_re,sigma_im)
% 
% INPUT
% - X           Clean values.
% - std_re/im   Standard deviation of normally distributed noise.
% 
% OUTPUT
% - X_noise     Noisy values.

[n_rows,n_cols] = size(X);

N_re = sigma_re * randn(n_rows,n_cols) .* abs(X);
N_im = sigma_im * randn(n_rows,n_cols) .* abs(X);
N = N_re + 1i*N_im;

N = currupt_with_bad_data(N,sigma_re,sigma_im,Bad_Data);

X_noisy = X + N;

end